INCLUDE "CONSTANTS"
INCLUDE "GLOBALS"

REMOTE_PROC=9

DATUM_IN AXIS(0)=1
DATUM_IN AXIS(1)=2
DATUM_IN AXIS(2)=3

'V_LIMIT AXIS(2)= 3000 * TABLE(comms_steppermm) / 60
'V_LIMIT AXIS(2)= 0

TABLE(comms_tool,VR(vr_tool))
TABLE(comms_atc,0)

TABLE(table_startingup,0)
TABLE(table_spindlerunning,OFF)
TABLE(table_eventhoming,0)
TABLE(table_movesmade,0)

TABLE(table_applistening,0)

IF IN(input_toolchangerfitted) = ON THEN
    TABLE(comms_usesecondlimits,1)
    TABLE(comms_tcremoved,0)
ELSE
    TABLE(comms_usesecondlimits,0)
    TABLE(comms_tcremoved,1)
ENDIF


TABLE(table_readupto,0)
TABLE(table_consumed,0)
TABLE(comms_feed,8667)

RUN "ESTOP",1
RUN "DOOROPEN",2
RUN "KNOBS",3

FOR ax = 0 TO 2

    BASE(ax)
    MERGE=ON
    LIMIT_BUFFERED=64
    CORNER_MODE=2+8


'    DECEL_ANGLE = 10 * (PI/180)
    DECEL_ANGLE = 10 * PI / 180

'    STOP_ANGLE = 20 * (PI/180)
    STOP_ANGLE = 18 * PI / 180

    'FULL_SP_RADIUS= 15*400
    FULL_SP_RADIUS= 6*400

    SCHEDULE_TYPE.6 = 0

    FORCE_SPEED = SPEED
    ENDMOVE_SPEED = SPEED

    AXIS_MODE = 4
NEXT ax

'BASE(3)
'ATYPE = 79

INTERP_FACTOR AXIS(3)=1


REPEAT
    WA(100)
UNTIL (TABLE(table_startingup) = 7)

RUN "consumer"

DIM dacoutput AS FLOAT
dacoutput = 0

DIM feedoutput AS FLOAT
feedoutput = 0

DIM feedspeed AS FLOAT
feedspeed = 0

DIM temp AS FLOAT

DIM islathe AS BOOLEAN
islathe = (VR(vr_machine) = microturnpro)

DIM isvmc AS BOOLEAN
isvmc = (VR(vr_machine) = vmc1300) OR (VR(vr_machine) = vmc1300pro)

DIM iscompact1000 AS BOOLEAN
iscompact1000 = (VR(vr_machine) = compact1000) OR (VR(vr_machine) = compact1000pro)

DIM isrouter2600 AS BOOLEAN
isrouter2600 = (VR(vr_machine) = router2600) OR (VR(vr_machine) = router2600pro) OR (VR(vr_machine) = router2600atc)

DIM isrouter6600 AS BOOLEAN
isrouter6600 = (VR(vr_machine) = router6600) OR (VR(vr_machine) = router6600pro) OR (VR(vr_machine) = router6600atc)

IF islathe THEN
    RUN "actualspeedreader"
ENDIF

DIM applistening, prevapplistening, prevwascancelled, prevairpressure, firstpass, input2viceron AS BOOLEAN
applistening = FALSE
prevapplistening = FALSE
prevwascancelled = FALSE
prevairpressure = TRUE
firstpass = TRUE
input2viceron = TRUE


DAC AXIS(0)=0

IF (TABLE(comms_remotecontrol) = ON) THEN
    TABLE(comms_safe,ON)
    raiseevent(comms_safe)
ENDIF

REPEAT
    WA(100)

    applistening =TABLE(table_applistening)

    IF (TABLE(comms_steppermm) <> gl_stepspermm) OR (applistening AND NOT prevapplistening) THEN
        gl_stepspermm = TABLE(comms_steppermm)
        setupaxes(gl_stepspermm)
    ENDIF

    IF (VR(vr_machine) = micromillpro) OR (VR(vr_machine) = microturnpro) THEN
        IF (TABLE(comms_speed) <> dacoutput) AND (TABLE(table_spindlerunning) = ON) THEN
            IF TABLE(comms_speed) < dacoutput THEN
                dacoutput = TABLE(comms_speed)
            ELSE
                'dacoutput = min(TABLE(comms_speed), dacoutput + (TABLE(comms_speed)/10))
                IF TABLE(comms_speed) < dacoutput + (TABLE(comms_speed)/5) THEN
                    dacoutput = TABLE(comms_speed)
                ELSE
                    dacoutput = dacoutput + (TABLE(comms_speed)/5)
                ENDIF
            ENDIF
            'dacoutput = TABLE(comms_speed)
            setspindlespeed(dacoutput)

        ELSEIF (TABLE(table_spindlerunning) = OFF) THEN
            DAC AXIS(0)=0
        ENDIF
    ELSEIF TABLE(comms_speed) <> dacoutput THEN
        dacoutput = TABLE(comms_speed)
        IF (TABLE(table_spindlerunning) = ON) THEN
            setspindlespeed(TABLE(comms_speed))
        ENDIF

    ENDIF

    IF (iscompact1000) OR (isrouter2600)OR (isrouter6600) THEN
        IF (IN(input_vacuumbedbutton) = ON) THEN ' Pump on switch
            OP(output_vacuumbedon,ON)
        ELSEIF (notinauto() AND (TABLE(table_spindlerunning) = OFF)) THEN' turn pump off if not in Auto and spindle
'stopped
            OP(output_vacuumbedon,OFF)
        ENDIF
    ENDIF

'    IF TABLE(table_maxfeed) <> feedoutput THEN
 '       feedoutput = TABLE(table_maxfeed)
 '       setfeedspeed()
 '   ENDIF

 '   IF TABLE(comms_feed) <> feedspeed THEN
 '       feedspeed = TABLE(comms_feed)
 '       setfeedspeed()
 '   ENDIF
    TABLE(table_speedrequest,0)

    IF TABLE(comms_task) > 0 THEN
        temp = TABLE(comms_task)
        SELECT_CASE temp :
            CASE 7'comms_tool
                toolchange(TABLE(comms_tool))



                TABLE(comms_task,0)
            CASE 18'comms_mcode
                handlemcode() 'MCode
            CASE 72'comms_numaxes
                'Number of axes
                TABLE(comms_task,0)
            CASE ELSE
                TABLE(comms_task,0)
        END_CASE

    ENDIF

    IF TABLE(comms_needtohome) > 0 THEN
        homeaxis(TABLE(comms_needtohome)-1)
        TABLE(comms_needtohome,0)
    ENDIF

    IF islathe THEN
        readlathspeed()
    ENDIF

    IF (isvmc) THEN
        IF (IN(input_toolrelease) = ON) AND checkavailableairpressure() AND (_
                IN(input_guardclosed) = OFF) THEN
            drawbarunclamp()
            WAIT UNTIL (IN(input_toolrelease) = OFF)
            drawbarclamp()
            ' check FOR button press
        ENDIF


        IF prevairpressure <> checkavailableairpressure() THEN
            prevairpressure = checkavailableairpressure()
            IF (prevairpressure) THEN
                TABLE(comms_airpressure,1)
            ELSE
                TABLE(comms_airpressure,0)
            ENDIF
            raiseevent(comms_airpressure)
        ENDIF
    ENDIF

    IF (TABLE(comms_remotechuck)) THEN
        IF (firstpass) OR (input2viceron <> (IN(input_input2vicer) = ON)) THEN
            IF IN(input_input2vicer) = ON THEN
                setvice(1)
                OP(output_auxout1r, OFF)
            ELSE
                setvice(0)
                OP(output_auxout1r, ON)
            ENDIF
        ENDIF
        input2viceron = (IN(input_input2vicer) = ON)
    ENDIF
    IF applistening AND NOT prevapplistening THEN
        IF (TABLE(comms_remotecontrol) = ON) THEN
            TABLE(comms_safe,ON)
            raiseevent(comms_safe)
        ELSEIF (IN(input_guardclosed) = OFF) THEN
            TABLE(comms_safe,OFF)
            raiseevent(comms_safe)
        ENDIF
    ENDIF



    IF (TABLE(comms_reset) > 0) THEN
        IF NOT prevwascancelled THEN
            starttime = TIME
            prevwascancelled = TRUE
        ENDIF
        IF TIME - prevwascancelled > 1 THEN
            TABLE(comms_reset,0)
            prevwascancelled = FALSE
        ENDIF
    ENDIF

    checkisidle()
    getposition()

    prevapplistening = applistening
    firstpass = FALSE
UNTIL FALSE





